/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HexDump;
import com.ibm.hsc.common.util.HscPrintStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HardwareServerMessage {
    private static boolean mDumpComplete = false;
    private static final int HS_HEADER_LENGTH = 30;
    public static final byte HS_PACKET_HEADER_BYTE = -85;
    public static final int HS_MAJ_QUERY = 16;
    public static final int HS_MAJ_REGISTER = 32;
    public static final int HS_MAJ_CSP_PASS_THROUGH = 64;
    public static final int HS_MAJ_FSP_PASS_THROUGH = 80;
    public static final int HS_MAJ_BPA_PASS_THROUGH = 128;
    public static final int HS_MAJ_VSERIAL = 144;
    public static final int HS_MAJ_ASYNCH = 160;
    public static final int HS_MAJ_ERROR = 176;
    public static final int HS_MIN_QUERY_BPA_LIST_REQ = 17;
    public static final int HS_MIN_QUERY_BPA_LIST_RSP = 18;
    public static final int HS_MIN_QUERY_BPA_LIST_ERR = 19;
    public static final int HS_MIN_QUERY_CSP_LIST_REQ = 20;
    public static final int HS_MIN_QUERY_CSP_LIST_RSP = 21;
    public static final int HS_MIN_QUERY_CSP_LIST_ERR = 22;
    public static final int HS_MIN_QUERY_GLOBAL_CSP_LIST_REQ = 23;
    public static final int HS_MIN_QUERY_GLOBAL_CSP_LIST_RSP = 24;
    public static final int HS_MIN_QUERY_GLOBAL_CSP_LIST_ERR = 25;
    public static final int HS_MIN_QUERY_GLOBAL_BPA_LIST_REQ = 26;
    public static final int HS_MIN_QUERY_GLOBAL_BPA_LIST_RSP = 27;
    public static final int HS_MIN_QUERY_GLOBAL_BPA_LIST_ERR = 28;
    public static final int HS_MIN_QUERY_VERSION_REQ = 29;
    public static final int HS_MIN_QUERY_VERSION_RSP = 30;
    public static final int HS_MIN_QUERY_VERSION_ERR = 31;
    public static final int HS_MIN_QUERY_FSP_LIST_REQ = 32;
    public static final int HS_MIN_QUERY_FSP_LIST_RSP = 33;
    public static final int HS_MIN_QUERY_FSP_LIST_ERR = 34;
    public static final int HS_MIN_QUERY_FSP_DATA_REQ = 35;
    public static final int HS_MIN_QUERY_FSP_DATA_RSP = 36;
    public static final int HS_MIN_QUERY_FSP_DATA_ERR = 37;
    public static final int HS_MIN_QUERY_VSLIPD_REQ = 50;
    public static final int HS_MIN_QUERY_VSLIPD_RSP = 51;
    public static final int HS_MIN_QUERY_VSLIPD_ERR = 52;
    public static final int HS_MIN_REGISTER_FNM_REQ = 49;
    public static final int HS_MIN_REGISTER_FNM_RSP = 50;
    public static final int HS_MIN_REGISTER_FNM_ERR = 51;
    public static final int HS_MIN_REGISTER_HDWR_SVR_REQ = 52;
    public static final int HS_MIN_REGISTER_HDWR_SVR_RSP = 53;
    public static final int HS_MIN_REGISTER_HDWR_SVR_ERR = 54;
    public static final int HS_MIN_REGISTER_EL_REQ = 55;
    public static final int HS_MIN_REGISTER_EL_RSP = 56;
    public static final int HS_MIN_REGISTER_EL_ERR = 57;
    public static final int HS_MIN_REGISTER_ASYNC_REQUEST = 64;
    public static final int HS_MIN_REGISTER_ASYNC_RESPONSE = 65;
    public static final int HS_MIN_REGISTER_ASYNC_FAILURE = 66;
    public static final int HS_MIN_REGISTER_RPC_OUT_REQUEST = 67;
    public static final int HS_MIN_REGISTER_RPC_OUT_RESPONSE = 68;
    public static final int HS_MIN_REGISTER_RPC_OUT_FAILURE = 69;
    public static final int HS_MIN_REGISTER_CIM_CLIENTD_REQUEST = 70;
    public static final int HS_MIN_REGISTER_CIM_CLIENTD_RESPONSE = 71;
    public static final int HS_MIN_REGISTER_CIM_CLIENTD_FAILURE = 72;
    public static final int HS_MIN_BPA_NO_DATA_REQ = 81;
    public static final int HS_MIN_BPA_NO_DATA_RSP = 82;
    public static final int HS_MIN_BPA_NO_DATA_ERR = 83;
    public static final int HS_MIN_BPA_DATA_REQ = 84;
    public static final int HS_MIN_BPA_DATA_RSP = 85;
    public static final int HS_MIN_BPA_DATA_ERR = 86;
    public static final int HS_MIN_BPA_ADDBPC_REQ = 118;
    public static final int HS_MIN_BPA_ADDBPC_RES = 119;
    public static final int HS_MIN_BPA_ADDBPC_ERR = 110;
    public static final int HS_MIN_BPA_CHG_PWD_REQ = 124;
    public static final int HS_MIN_BPA_CHG_PWD_RES = 125;
    public static final int HS_MIN_BPA_CHG_PWD_ERR = 126;
    public static final int HS_MIN_BPA_RMBPC_REQ = 124;
    public static final int HS_MIN_BPA_RMBPC_RES = 125;
    public static final int HS_MIN_BPA_RMBPC_ERR = 126;
    public static final int HS_MIN_BPA_PLATPWD_REQ = 127;
    public static final int HS_MIN_BPA_PLATPWD_RES = 128;
    public static final int HS_MIN_BPA_PLATPWD_ERR = 129;
    public static final int HS_MIN_CSP_REQ = 87;
    public static final int HS_MIN_CSP_RSP = 88;
    public static final int HS_MIN_CSP_ERR = 89;
    public static final int HS_MIN_FSP_REQ = 96;
    public static final int HS_MIN_FSP_RSP = 97;
    public static final int HS_MIN_FSP_ERR = 98;
    public static final int HS_MIN_FSP_ADDCEC_REQ = 99;
    public static final int HS_MIN_FSP_ADDCEC_RES = 100;
    public static final int HS_MIN_FSP_ADDCEC_ERR = 101;
    public static final int HS_MIN_FSP_CHG_PW_REQ = 102;
    public static final int HS_MIN_FSP_CHG_PW_RES = 103;
    public static final int HS_MIN_FSP_CHG_PW_ERR = 104;
    public static final int HS_MIN_FSP_RMCEC_REQ = 105;
    public static final int HS_MIN_FSP_RMCEC_RES = 106;
    public static final int HS_MIN_FSP_RMCEC_ERR = 107;
    public static final int HS_MIN_FSP_PLATPWD_REQ = 108;
    public static final int HS_MIN_FSP_PLATPWD_RES = 109;
    public static final int HS_MIN_FSP_PLATPWD_ERR = 110;
    public static final int HS_MIN_FSP_PLATFORM_PASSWORD = 99;
    public static final int HS_MIN_FSP_SET_PASSWORD = 102;
    public static final int HS_MIN_CSP_ASYNC = 112;
    public static final int HS_MIN_BPA_ASYNC = 113;
    public static final int HS_MIN_BPA_UP_ASYNC = 114;
    public static final int HS_MIN_BPA_DOWN_ASYNC = 115;
    public static final int HS_MIN_CSP_UP_ASYNC = 116;
    public static final int HS_MIN_CSP_DOWN_ASYNC = 117;
    public static final int HS_MIN_FSP_ASYNC = 122;
    public static final int HS_MIN_FSP_VPORT_CHANGE_ASYNC = 123;
    public static final int HS_MIN_VSERIAL_CHANGE_ASYNC = 124;
    public static final int HS_MIN_VSERIAL_LIST_REQUEST = 1;
    public static final int HS_MIN_VSERIAL_LIST_RESPONSE = 2;
    public static final int HS_MIN_VSERIAL_LIST_FAILURE = 3;
    public static final int HS_MIN_VSERIAL_OPEN_REQUEST = 4;
    public static final int HS_MIN_VSERIAL_OPEN_RESPONSE = 5;
    public static final int HS_MIN_VSERIAL_OPEN_FAILURE = 6;
    public static final int HS_MIN_VSERIAL_CLOSE_REQUEST = 7;
    public static final int HS_MIN_VSERIAL_CLOSE_RESPONSE = 8;
    public static final int HS_MIN_VSERIAL_CLOSE_FAILURE = 9;
    public static final int HS_MIN_VSERIAL_WRITE_REQUEST = 10;
    public static final int HS_MIN_VSERIAL_WRITE_RESPONSE = 11;
    public static final int HS_MIN_VSERIAL_WRITE_FAILURE = 12;
    public static final int HS_MIN_VSERIAL_INBOUND = 13;
    public static final short VSERIAL_RAW_PROTOCOL = 1;
    public static final short VSERIAL_SLIP_PROTOCOL = 2;
    public static final byte VSERIAL_CE_AUTH_TYPE = 4;
    public static final byte VSERIAL_DEV_AUTH_TYPE = 5;
    public static final int HS_RC_INVALID_PACKET = 1000;
    public static final int HS_RC_INVALID_MAJOR_OPCODE = 1001;
    public static final int HS_RC_INVALID_MINOR_OPCODE = 1002;
    public static final int HS_RC_BAD_VPORT = 1003;
    public static final int HS_RC_MSG_TIMEOUT = 1004;
    public static final int HS_RC_BPA_REJECTED_PACKET = 1005;
    public static final int HS_RC_BPA_REJECTED_BUSY = 1006;
    public static final short VSERIAL_FORCE_CLOSE = 255;
    private byte[] m_bytes;

    public static void setCompleteDump(boolean bl) {
        mDumpComplete = bl;
    }

    public static HardwareServerMessage buildHSVersionQuery() {
        return new HardwareServerMessage(16, 29, 0, 0, null);
    }

    public static HardwareServerMessage buildHSCspQuery() {
        return new HardwareServerMessage(16, 20, 0, 0, null);
    }

    public static HardwareServerMessage buildHSFspQuery() {
        return new HardwareServerMessage(16, 32, 0, 0, null);
    }

    public static HardwareServerMessage buildFspDataQuery(int n) {
        return new HardwareServerMessage(16, 35, n, 0, null);
    }

    public static HardwareServerMessage buildFspPassthrough(int n, byte[] byArray) {
        return new HardwareServerMessage(80, 96, n, 0, byArray);
    }

    public static HardwareServerMessage buildFspPassthrough(int n, int n2, byte[] byArray) {
        return new HardwareServerMessage(80, 96, n, n2, byArray);
    }

    public static HardwareServerMessage buildFspPassthrough(int n, int n2, byte[] byArray, short s) {
        return new HardwareServerMessage(80, 96, n, n2, byArray, s);
    }

    public static HardwareServerMessage buildCustomHWSMessage(int n, int n2, int n3, int n4, byte[] byArray) {
        return new HardwareServerMessage(n, n2, n3, n4, byArray);
    }

    public static HardwareServerMessage buildAsyncRegistrationRequest(int n, int n2) {
        return new HardwareServerMessage(32, 64, n, n2, null);
    }

    public static HardwareServerMessage buildCIMClientDaemonRegistrationRequest(int n) {
        return new HardwareServerMessage(32, 70, 0, n, null);
    }

    public static HardwareServerMessage buildMegamouthRPCRegistrationRequest(int n) {
        return new HardwareServerMessage(32, 67, 0, n, null);
    }

    public static HardwareServerMessage buildVserialListRequest(int n, int n2) {
        return new HardwareServerMessage(144, 1, n, n2, null);
    }

    public static HardwareServerMessage buildVserialOpenRequest(int n, int n2, short s, short s2, short s3, short s4) {
        byte[] byArray = new byte[8];
        HardwareServerMessage.shortToBytes(s, byArray, 0);
        HardwareServerMessage.shortToBytes(s2, byArray, 2);
        HardwareServerMessage.shortToBytes(s3, byArray, 4);
        HardwareServerMessage.shortToBytes(s4, byArray, 6);
        return new HardwareServerMessage(144, 4, n, n2, byArray);
    }

    public static HardwareServerMessage buildVserialAuthenticatedOpenRequest(int n, int n2, short s, short s2, short s3, short s4, byte by, String string) {
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[13 + byArray.length];
        HardwareServerMessage.shortToBytes(s, byArray2, 0);
        HardwareServerMessage.shortToBytes(s2, byArray2, 2);
        HardwareServerMessage.shortToBytes(s3, byArray2, 4);
        HardwareServerMessage.shortToBytes(s4, byArray2, 6);
        byArray2[8] = by;
        byArray2[9] = 0;
        HardwareServerMessage.shortToBytes((short)(byArray.length + 1), byArray2, 10);
        System.arraycopy(byArray, 0, byArray2, 12, byArray.length);
        return new HardwareServerMessage(144, 4, n, n2, byArray2);
    }

    public static HardwareServerMessage buildVserialCloseRequest(int n, int n2, short s, short s2, boolean bl) {
        short s3 = 0;
        byte[] byArray = new byte[6];
        HardwareServerMessage.shortToBytes(s, byArray, 0);
        HardwareServerMessage.shortToBytes(s2, byArray, 2);
        if (bl) {
            s3 = 255;
        }
        HardwareServerMessage.shortToBytes(s3, byArray, 4);
        return new HardwareServerMessage(144, 7, n, n2, byArray);
    }

    public static HardwareServerMessage buildVserialWrite(int n, int n2, short s, short s2, byte[] byArray, int n3) {
        byte[] byArray2 = new byte[6 + n3];
        HardwareServerMessage.shortToBytes(s, byArray2, 0);
        HardwareServerMessage.shortToBytes(s2, byArray2, 2);
        HardwareServerMessage.shortToBytes((short)n3, byArray2, 4);
        System.arraycopy(byArray, 0, byArray2, 6, n3);
        return new HardwareServerMessage(144, 10, n, n2, byArray2);
    }

    public HardwareServerMessage(int n, int n2, int n3, int n4, byte[] byArray) {
        int n5 = byArray != null ? byArray.length : 0;
        this.m_bytes = new byte[30 + n5];
        this.m_bytes[3] = -85;
        this.m_bytes[2] = -85;
        this.m_bytes[1] = -85;
        this.m_bytes[0] = -85;
        this.m_bytes[4] = (byte)(n & 0xFF);
        this.m_bytes[5] = (byte)(n2 & 0xFF);
        HardwareServerMessage.shortToBytes((short)n5, this.m_bytes, 6);
        HardwareServerMessage.intToBytes(n3, this.m_bytes, 8);
        this.m_bytes[12] = 0;
        this.m_bytes[13] = 0;
        HardwareServerMessage.intToBytes(n4, this.m_bytes, 14);
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.m_bytes, 30, byArray.length);
        }
    }

    public HardwareServerMessage(int n, int n2, int n3, int n4, byte[] byArray, short s) {
        this(n, n2, n3, n4, byArray);
        HardwareServerMessage.shortToBytes(s, this.m_bytes, 12);
    }

    public HardwareServerMessage(InputStream inputStream) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[30];
        for (n = 0; n < 30; n += n2) {
            n2 = inputStream.read(byArray, n, 30 - n);
            if (n2 >= 0) {
                continue;
            }
            throw new IOException("end of input");
        }
        n2 = HardwareServerMessage.bytesToUShort(byArray, 6);
        this.m_bytes = new byte[30 + (n2 &= 0xFFFF)];
        System.arraycopy(byArray, 0, this.m_bytes, 0, 30);
        while (n < this.m_bytes.length) {
            int n3 = inputStream.read(this.m_bytes, n, this.m_bytes.length - n);
            if (n3 >= 0) {
                n += n3;
                continue;
            }
            throw new IOException("end of input");
        }
    }

    public int getMajorOpCode() {
        return this.m_bytes[4] & 0xFF;
    }

    public int getMinorOpCode() {
        return this.m_bytes[5] & 0xFF;
    }

    public int getCorrelator() {
        return HardwareServerMessage.bytesToUInt(this.m_bytes, 14);
    }

    public int getVirtualPort() {
        return HardwareServerMessage.bytesToUInt(this.m_bytes, 8);
    }

    public byte[] getVirtualPortInByteArray() {
        byte[] byArray = new byte[]{this.m_bytes[8], this.m_bytes[9], this.m_bytes[10], this.m_bytes[11]};
        return byArray;
    }

    public boolean isHSError() {
        return 176 == this.getMajorOpCode();
    }

    public byte[] getFspUniqueId() {
        byte[] byArray = new byte[]{this.m_bytes[38], this.m_bytes[39], this.m_bytes[40], this.m_bytes[41]};
        return byArray;
    }

    public boolean isAsyncData() {
        if (this.m_bytes.length < 45) {
            return false;
        }
        int n = this.m_bytes[44] & 0xFF;
        System.out.println("async flag " + n);
        return (n & 4) == 0 && (n & 0x40) == 0;
    }

    public int getErrorCode() {
        if (this.m_bytes.length > 34) {
            return HardwareServerMessage.bytesToUInt(this.m_bytes, 30);
        }
        return 0;
    }

    public void writeMessage(OutputStream outputStream) throws IOException {
        outputStream.write(this.m_bytes);
        outputStream.flush();
    }

    public byte[] toBytes() {
        return this.m_bytes;
    }

    public byte[] getPayload() {
        byte[] byArray = new byte[this.m_bytes.length - 30];
        System.arraycopy(this.m_bytes, 30, byArray, 0, byArray.length);
        return byArray;
    }

    public int getVport() {
        if (this.m_bytes.length >= 12) {
            return HardwareServerMessage.bytesToUInt(this.m_bytes, 8);
        }
        return -1;
    }

    public boolean hasFSPMessage() {
        return 80 == this.getMajorOpCode() && (96 == this.getMinorOpCode() || 97 == this.getMinorOpCode());
    }

    public String prettyPrintMessage() {
        if (HscPrintStream.isTraceActive()) {
            StringBuffer stringBuffer = new StringBuffer("\nHS Message:\n");
            stringBuffer.append(" Major = 0x").append(Integer.toHexString(this.getMajorOpCode()));
            stringBuffer.append(" Minor = 0x").append(Integer.toHexString(this.getMinorOpCode()));
            stringBuffer.append(" Correlator = 0x").append(Integer.toHexString(this.getCorrelator()));
            stringBuffer.append(" vPort = 0x").append(Integer.toHexString(this.getVirtualPort()));
            stringBuffer.append("\n HS Header:");
            stringBuffer.append(new HexDump(this.m_bytes, 0, 30, mDumpComplete));
            stringBuffer.append("\n HS Payload:");
            if (this.hasFSPMessage()) {
                stringBuffer.append(this.prettyPrintFSPMessage());
            } else {
                stringBuffer.append(new HexDump(this.m_bytes, 30, this.m_bytes.length - 30, mDumpComplete));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String prettyPrintFSPMessage() {
        if (HscPrintStream.isTraceActive()) {
            StringBuffer stringBuffer = new StringBuffer("\n  FSP Message:");
            stringBuffer.append(new HexDump(this.m_bytes, 30, this.m_bytes.length - 30, mDumpComplete));
            return stringBuffer.toString();
        }
        return "";
    }

    public String toString() {
        return this.prettyPrintMessage();
    }

    public static final void intToBytes(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    public static final void shortToBytes(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)(s >> 8 & 0xFF);
    }

    public static final int bytesToUInt(byte[] byArray, int n) {
        if (byArray[n + 3] >= 0) {
            return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
        }
        return -1;
    }

    public static final long bytesToUInt32(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    public static final String bytesToIPv4String(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(byArray[n + 3] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(byArray[n + 2] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(byArray[n + 1] & 0xFF);
        stringBuffer.append(".");
        stringBuffer.append(byArray[n + 0] & 0xFF);
        return stringBuffer.toString();
    }

    public static final int bytesToUShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) + (byArray[n + 1] & 0xFF) * 256;
    }

    public static void main(String[] stringArray) {
        System.out.println("HSMessage Unit Test");
        HardwareServerMessage hardwareServerMessage = HardwareServerMessage.buildVserialAuthenticatedOpenRequest(4, 0xCABCAB, (short)8, (short)7, (short)6, (short)5, (byte)4, "authstr");
        System.out.println("authmsg " + hardwareServerMessage.toString());
        byte[] byArray = new byte[8];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(i + 17);
        }
        System.out.println("byte array = " + new HexDump(byArray));
        System.out.println("uint0-3 = 0x" + Integer.toHexString(HardwareServerMessage.bytesToUInt(byArray, 0)));
        System.out.println("ushort4-5 = 0x" + Integer.toHexString(HardwareServerMessage.bytesToUShort(byArray, 4)));
        byte[] byArray2 = new byte[8];
        HardwareServerMessage.shortToBytes((short)4660, byArray2, 2);
        System.out.println("short 0x1234 to array[2-3] = " + new HexDump(byArray2));
        byArray2 = new byte[8];
        HardwareServerMessage.intToBytes(305419896, byArray2, 2);
        System.out.println("int 0x12345678 to array[2-5] = " + new HexDump(byArray2));
        byArray2 = new byte[8];
        HardwareServerMessage.intToBytes(18, byArray2, 2);
        System.out.println("int 0x12 to array[2-5] = " + new HexDump(byArray2));
    }

    static {
        try {
            File file = new File("/opt/hsc/data/completeDump");
            mDumpComplete = file.exists();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            mDumpComplete = false;
        }
    }
}

